#!/usr/bin/perl

#
#  REF: resoosearch.pl
#  ResooSite v.0.9.6.6-1 -(p)Resoo 2002-2005
#  (c)2005 - pascal blain / GNU GPL - General Public License
#  http://www.resoo.com/resoosite
#  pascal@resoo.org
#
my $ver = "resoosearch v.0.9.6.6-1 (c)2005";

require "resooconf.pl";

#use strict; ## [%filesindex]

## configuration utilisateur niveau 1 (resooconf.pl)
#my $dir_txt = "../txt";
#my $mesgdir = "../bbs/message";
#my $domaincgi = "http://pascal.resoo.org/resoo/cgi-bin";
#my $private = "private";
#my $font = "";
#my $finfont = "";
#my $fontpetite = "";
#my $finfontpetite = "";
#my $fontpetite_col = "";
#my $fontstitre = "";
#my $finfontstitre = "";
#my $fonttitre = "";
#my $finfonttitre = "";
#my $title = "resoo.org";
#my $urlperso = "http://www.resoo.org";
#my $couleur_cad = "#ffffff";
my $searchTXT = 1;
my $searchHTM = 0;
my $searchCAL = 0;
my $searchBBS = $bbs-1; #$bbs=1: pas de forum, $bbs=2/3: forum actif

## configuration utilisateur niveau 2
my @searchTXT = ($searchTXT,$dir_txt,"Article");
my @searchHTM = ($searchHTM,"","");
my @searchCAL = ($searchCAL,"","");
my @searchBBS = ($searchBBS,$mesgdir,"$forumtitre"); ## titre aussi utilis dans le formatage du titre des rponses
my $searchTous = "Tout"; ## le titre pour la recherche sur tous les rpertoires
my $site_url = $domaincgi; ## l'url de base des liens "rponses" proposs
my $usetitre = 1; ## 1 pour afficher le titre des page, 0 pour utiliser le lien
my $useindex = 2; ## 1 pour recherche sur rpertoire index, 0 pour recherche directe sur fichiers, 2 pour "1" ET "0" en cas d'chec
my $maxsearch = 10; ## le nombre de rponses par page
my $maxmot = 4; ## le nombre de mots maximum (non inclus dans @badexpr) sur lesquels porte la recherche
my $descriptionlength = 100; ## le nombre de caractres affichs dans les rponses de chaque cot des mots trouvs
my @badexpr = ('un','une','des','le','la','les','mon','ton','son','sa','nos','vos','ses','leur','leurs','l','s','','du','a','au','aux','est','en','et','ou');

## debug option
my $search_mode = "-s"; ## le mode par dfaut de la console [s|sx|si|d|dx|di]
my $debug = 0; ## 1 pour afficher les commentaires, sinon 0

## secure et defaut
my @validsearch = (\@searchTXT,\@searchHTM,\@searchCAL,\@searchBBS);
my @validsearch_url;
foreach my $searchDIR(@validsearch){
    if (@$searchDIR[0]){ push(@validsearch_url, @$searchDIR[1]);}
}
my $defaut_rep = $validsearch_url[0];
my $datasearch = "index.dat"; ## le nom du fichier de stockage de chaque rpertoire index
my $action = 0;
my $searchtime;
my ($Args,$type,$rep,$repnew,$mot,$meth,$pagerep);
my $meth = 6;
my $type = "X";
my $util = "";
my $pass = "";

## traite le formulaire
$Args = $ENV{QUERY_STRING};
if ($Args){
    $Args =~ s/%([0-9A-F][0-9A-F])/pack("C",oct("0x$1"))/ge;
    $Args =~ tr/+/,/;
    $Args =~ s/^1=//g;
    $Args =~ s/\&[2345]=/\&/g;
    $Args =~ s/ /,/g;
    $Args =~ s/\&/ /g;
    $Args =~ s/[\;\"]//g;
    @ARGV = split(/ /, $Args);
}



## let's go !

print "Content-type: text/html\; charset=ISO-8859-1\n\n";

## ce que l'utilisateur veut faire
if ($ARGV[0] =~ /^-/) {
    if ($ARGV[0] eq "-h") { $action = 1; }
    elsif ($ARGV[0] eq "-x") { $action = 2; $rep = $defaut_rep; $mot = $ARGV[1]; }
    elsif ($ARGV[0] eq "-s") { $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-si") { $useindex = 1; $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-sx") { $useindex = 0; $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-d") { $debug = 1; $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-di") { $useindex = 1; $debug = 1; $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-dx") { $useindex = 0; $debug = 1 ; $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    elsif ($ARGV[0] eq "-i") { $action = 3; $util = $ARGV[1]; $pass = $ARGV[2]; $rep = $ARGV[3]; }
    elsif ($ARGV[0] eq "-id") { $debug = 1; $action = 3; $util = $ARGV[1]; $pass = $ARGV[2]; $rep = $ARGV[3]; }
    else { print "~/resoosearch $ARGV[0] ???<br>\n<br>\n"; print "~/resoosearch.pl -h  (pour lire l'aide)<br>\n<br>\n"; print "~/resoosearch.pl  (pour affichage console)<br>\n<br>\n"; }
    shift(@ARGV);
}
else{
## affichage console
    if (!$debug){
	&head_gen;
	&pao_mini_haut;
	print "<div align=\"center\">";
	print "\n<br>\n$fonttitre Recherche / <a href=\"$urlperso\" TARGET=\"_top\">$title</a> $finfontstitre\n<br>\n";
	print "\n<br>\n$fontstitre$ver$finfontstitre\n<br>\n";
    }
    search_console();
    if (!$debug){
	print "</div>";
	&pao_mini_bas;
	&foot_gen;
    }
    else{ print "<br>\n<br>\n$ver<br>\n<br>\n"; }
}

if ($debug){$searchtime = time();}

if ($action == 1){
    print "<br>\n<br>\n$ver<br>\n<br>\n
           ~/resoosearch $ARGV[0] ???<br>\n<br>\n
           usage:<br>\n<br>\n
           ~/resoosearch?[]\n<br>
             [ sans paramtre => mode console html ]<br>\n<br>
           ~/resoosearch?[-h]\n<br>
             [ -h => affiche cette page d'aide ]<br>\n<br>
           ~/resoosearch?-[s|si|sx|d|di|dx]&[T|X]&[repertoire]&[mots]&[method]\n<br>
             [ -s  => mode recherche <defaut>]<br>
             [ -si => mode recherche <index> ]<br>
             [ -sx => mode recherche <file>  ]<br>
             [ -d  => mode -s  + option \"bavard\" ]<br>
             [ -di => mode -si + option \"bavard\" ]<br>
             [ -dx => mode -sx + option \"bavard\" ]<br>
             [ T => recherche dans le titre seulement ]<br>
             [ X => recherche dans tout le document   ]<br>
             [ repertoire: le (ou les) rpertoire(s)  parcourir ]<br>
             [ mots: le (ou les) mot(s)  rechercher             ]<br>
             [ method: 1, 2, 3, 4, 5, 6 ou 7 ]<br>\n<br>
             [ ils sera proposs $maxsearch documents rponses par page ]<br>\n<br>
           ~/resoosearch?[-x]&[mots]\n<br>
             [ -x  => mode recherche <defaut>]<br>
             [ (toutes les valeurs par dfauts seront utilises) ]<br>
             [ mots: le (ou les) mot(s)  rechercher             ]<br>\n<br>
           ~/resoosearch?[-i]&user&password&[repertoire]\n<br>
             [ -i => mode indexation           ]<br>
             [ user:       login d'utilisateur                   ]<br>
             [ password:   mot de passe utilisateur              ]<br>
             [ repertoire: le (ou les) rpertoire(s)  parcourir ]<br>\n<br>\n";
}

if ($action == 2){
    if (!$debug){
	&head_gen;
	&pao_mini_haut;
	print "<div align=\"center\">";
	print "\n<br>\n$fonttitre Recherche / <a href=\"$urlperso\" TARGET=\"_top\">$title</a> $finfontstitre\n<br>\n";
	print "\n<br>\n$fontstitre$ver$finfontstitre\n<br>\n";
    }
    else{
	print "\n$ver<br>\n<br>\n";
    }
    if ($mot){
	search_console2($mot);
    }
    my $pass = 0;
    if ((!$meth) or ($meth > 7)){$meth = 4;}
    my $max_search = $maxsearch;
    my $pagesaute = $pagerep*$maxsearch;
    my @rep = split(/,/, $rep);
    my $method = $meth;
    my $expr = $mot;
    if (!$expr){
	$method = 0;
    }
    $expr =~ s/,/ /g; ## utilise pour recherche "phrase exacte"
    my @expr = ();
    my $max_mot;
    my @maxexpr = split(/ /, $expr);
    foreach $max_mot(@maxexpr){
	if (($maxmot) and (!grep(/$max_mot/i, @badexpr))){
	    push(@expr, $max_mot);
	    $maxmot--;
	}
    }
    $maxmot = @expr;
    if (!$maxmot){
	$method = 0;
    }
    my @DataVu = ();
    if($debug){print "RECHERCHE : <b>$expr</b> (<i>$maxsearch rponses/page maximum</i>) - [ page ".($pagerep+1)." ]<br>\n
           -- mthode (elle sont excutes par ordre dcroissant  partir de la mthode choisie - par dfaut mthode 4)<br>\n
           -- methode \# 4 = recherche de la phrase exacte (en premier)<br>\n
           -- methode \# 3 = recherche tendue de tous les mots (phrase dans le dsordre, sans les \"badwords\")<br>\n
           -- methode \# 2 = recherche stricte d'au moins un des mots (sans les \"badwords\")<br>\n
           -- methode \# 1 = recherche tendue d'au moins un des mots (sans les \"badwords\")<br>\n
           -- methode restrictive:<br>\n
           -- methode \# 7 = mthode 4 (seulement)<br>\n
           -- methode \# 6 = mthode 4 puis 3 (seulement)<br>\n
           -- methode \# 5 = mthode 3 (seulement)<br>\n";} ### debug
    while ($method){
	foreach $repnew(@rep) {
	    if ($max_search >= 0){ ## sinon inutile d'aller plus loin...
		if ($debug){print "\n<br>\n<br>************************************<br>\nRepertoire $repnew (<i>methode \# $method</i>)\n";} ### debug
		my $useindex_local = $useindex;
		my (@DataDir,$data,$dataindex,@IndexDat);
		if (grep(/^$repnew$/, @validsearch_url)){
		    opendir (DIR, $repnew);
		}
		else{
		    opendir (DIR, $defaut_rep);
		    $repnew = $defaut_rep;
		}
		if ($useindex){
		    if ($debug){print "\n<br>\n\nIndex du rpertoire : $datasearch\n";} ### debug
		    if ($debug){if (-e "$repnew/$datasearch"){print " OK\n";} else{print " absent";}} ### debug
		    if (-e "$repnew/$datasearch"){
			open (INDEXDAT, "$repnew/$datasearch");
			@IndexDat = <INDEXDAT>;
			close(INDEXDAT);
			@DataDir = @IndexDat;
			close(DIR);
		    }
		    else{
			if ($useindex == 2){
			    $useindex_local = 0;
			}
		    }
		}
		if (!$useindex_local){
		    if ($debug){print "\n<br>\n\nIndex du rpertoire : inutilis (methode=file)\n";} ### debug
		    @DataDir=grep(!/^\.\.?$|(.*)\.idx$|(.*)\.top$|(.*)\.lst$|(.*)\.dat$/, readdir DIR);
		    close (DIR);
		    @DataDir = sort {$b <=> $a} (@DataDir);
		}
		foreach $data(@DataDir) {
		    if ($max_search >= 0){ ## sinon inutile d'aller plus loin...
			my (@DataFile,$Datafile,$DataFileWork,$testexpr,@DataIdx);
			if ($useindex){
			    @DataFile = split(/\]\[/, $data);
			    $data = @DataFile[0];
			}
			unless (grep(/$repnew-$data/, @DataVu)){
			    $pass = 0;
			    if ($useindex_local){
				($Datafile,@DataFile) = (dataindexprepare($type,@DataFile));
			    }
			    else {
				open (DATA, "$repnew/$data");
				@DataFile = <DATA>;
				close(DATA);
### sub dataprepare: mise en forme des fichiers  valuer pour la recherche
### la fonction retourne un texte "dformat" ($DataFile)
### et un tableau de valeur (@DataFile) dont:
###  -  la ligne 0 est le lien du document
###  -	la ligne 1 est le titre du document
###  -  la ligne 2 est le texte du document (titre+auteur+texte)
				($Datafile,@DataFile) = (dataprepare($data,$Datafile,$repnew,$type,@DataFile));
			    }
			    if (!$Datafile){
				@DataFile = ();
				push(@DataVu, "$repnew-$data");
			    }
			    if (($method == 4) or ($method == 6) or ($method == 7)){
				if (grep(/\b$expr\b/i, $Datafile)){  ## trouv !! mthode 4
				    if ($max_search == 0){ ##  une page suivante existe
					$method = 1;
					$max_search--;
				    }
				    elsif ($pagesaute){ ##  page suivante demande
					$pagesaute--;
					push(@DataVu, "$repnew-$data");
				    }
				    else { ## if ($max_search > 0) and (!$pagesaute)
					$pass++;
					push(@DataVu, "$repnew-$data");
###  -  la ligne 3 est le numero d'ordre de la rponse
					push(@DataFile, ($maxsearch-$max_search+1+$maxsearch*$pagerep));
					$max_search--;
					my $DataFile2 = @DataFile[2];
				    }
				}
			    }
			    elsif (($method == 3) or ($method == 5)){
				my $exprnum = @expr;
				foreach $testexpr(@expr){
				    if (grep(/\W$testexpr\W/i, $Datafile)){ ## test mthode 3
					$exprnum--;
				    }
				}
				if (!$exprnum){  ## trouv !! mthode 3
				    if ($max_search == 0){ ##  une page suivante existe
					$method = 1;
					$max_search--;
				    }
				    elsif ($pagesaute){ ##  page suivante demande
					$pagesaute--;
					push(@DataVu, "$repnew-$data");
				    }
				    else { ## if ($max_search > 0) and (!$pagesaute)
					$pass++;
					push(@DataVu, "$repnew-$data");
###  -  la ligne 3 est le numero d'ordre de la rponse
					push(@DataFile, ($maxsearch-$max_search+1+$maxsearch*$pagerep));
					$max_search--;
				    }
				}
			    }
			    elsif ($method == 2){
				my $exprnum = @expr;
				my $exprnum_ref = @expr;
				foreach $testexpr(@expr){
				    if (grep(/\W$testexpr\W/i, $Datafile)){ ## test mthode 2
					$exprnum--;
				    }
				}
				if ($exprnum_ref-$exprnum > 0){  ## trouv !! mthode 2
				    if ($max_search == 0){ ##  une page suivante existe
					$method = 1;
					$max_search--;
				    }
				    elsif ($pagesaute){ ##  page suivante demande
					$pagesaute--;
					push(@DataVu, "$repnew-$data");
				    }
				    else { ## if ($max_search > 0) and (!$pagesaute)
					$pass++;
					push(@DataVu, "$repnew-$data");
###  -  la ligne 3 est le numero d'ordre de la rponse
					push(@DataFile, ($maxsearch-$max_search+1+$maxsearch*$pagerep));
					$max_search--;
				    }
				}
			    }
			    elsif ($method == 1){
				my $exprnum = @expr;
				my $exprnum_ref = @expr;
				foreach $testexpr(@expr){
				    if (grep(/$testexpr/i, $Datafile)){  ## test mthode 1
					$exprnum--;
				    }
				}
				if ($exprnum_ref-$exprnum > 0){  ## trouv !! mthode 1
				    if ($max_search <= 0){ ##  une page suivante existe
					$method = 1;
					$max_search--;
				    }
				    elsif ($pagesaute){ ##  page suivante demande
					$pagesaute--;
					push(@DataVu, "$repnew-$data");
				    }
				    elsif (!$pass) { ## if ($max_search > 0){
					$pass++;
					push(@DataVu, "$repnew-$data");
###  -  la ligne 3 est le numero d'ordre de la rponse
					push(@DataFile, ($maxsearch-$max_search+1+$maxsearch*$pagerep));
					$max_search--;
				    }
				}
			    }
			    if ($pass){ ## au moins un test a russi
				foreach $testexpr(@expr){
				    my $DataFile2 = $DataFile[2];
				    if (grep(/$testexpr/i, $DataFile2)){
					$DataFileWork = $DataFile2;
					$DataFileWork =~ s/$testexpr(.*)/$testexpr/i;
					$DataFile2 = substr($DataFile2, 0, length($DataFileWork)+$descriptionlength);
					$DataFileWork = $DataFile2;
					$DataFileWork =~ s/(.*)$testexpr/$testexpr/i;
					$DataFile2 = substr($DataFile2, -($descriptionlength+length($DataFileWork)));
					$DataFile[2] =~ s/.*?$testexpr.{0,$descriptionlength}//i;
					foreach $testexpr(@expr){
					    if (!grep(/$testexpr/i, @badexpr)){
						$DataFile2 =~ s/($testexpr)/<strong>$1<\/strong>/gi;
					    }
					}
###  -  la ligne 4 est la description de la rponse
					unless ($DataFile2=~/^<.*/){
					    $DataFile2 =~ s/^\S+\s//;
					}
					unless ($DataFile2=~/.*>$/){
					    $DataFile2 =~ s/\s\S+$//;
					}
					$DataFile[4] = $DataFile[4]."(...) $DataFile2 (...)";
					$DataFile[4] =~ s/\(\.\.\.\)\(\.\.\.\)/\(\.\.\.\)/g;
				    }
				}
				print_link(@DataFile);
			    }
			}
		    }
		}
	    }
	}
	if (($method == 5) or ($method == 7)){
	    $method = 0;
	}
	elsif ($method >0){
	    $method--;
	}
    }
    if($debug){print "\n<br>----------------------------------------------<br>\n";} ### debug
    if (($max_search == $maxsearch) and ($expr)){
	print "<table width=600><tr><td BGCOLOR=\"$couleur_cad\">$font_cad";
#	if ($expr){
	    print "<br> <strong>Dsol, aucune rponse...</strong><br><br>\n";
#	}
	print "$finfont</td></tr></table>";
	if($debug){print "\n<br>----------------------------------------------<br>\n";} ### debug
    }
    elsif ($max_search < 0){
	print "\n<br><br><center>$font";
	if($pagerep){
	print "[ <a href=\"./resoosearch.pl?-s&$type&$rep&$mot&$meth&".($pagerep-1)."\">voir la page prcdente</a> ]\n";
	}
	print " - <i>Il y a d'autres rponses...</i> - \n";
	print "[ <a href=\"./resoosearch.pl?-s&$type&$rep&$mot&$meth&".($pagerep+1)."\">voir la page suivante</a> ]$finfont</center>\n";
	if($debug){print "\n<br>----------------------------------------------<br>\n";} ### debug
    }
    else{
	if($pagerep){
	    print "\n<br><br><center>$font";
	    print "[ <a href=\"./resoosearch.pl?-s&$type&$rep&$mot&$meth&".($pagerep-1)."\">voir la page prcdente</a> ]$finfont</center>\n";
	}
    }
    search_console($mot);
    if (!$debug){ print "</div>"; &pao_mini_bas; &foot_gen; }
    else{ print "<br>\n<br>\n$ver<br>\n<br>\n"; print "Temps de rponse : ".(time()-$searchtime)." seconde(s)<br>\n"; }
}

if ($action == 3){
    if (!$debug){
	&head_gen;
	&pao_mini_haut;
	print "<div align=\"center\">";
	print "\n<br>\n$fonttitre Recherche / <a href=\"$urlperso\" TARGET=\"_top\">$title</a> $finfontstitre\n<br>\n";
	print "\n<br>\n$fontstitre$ver$finfontstitre\n<br>\n";
    }
    else{
	print "\n$ver<br><br>\n"; ### debug
    }
    if (verify($util,$pass)){
	print "Indexation : lancement...<br>\n"; ### debug
	my @rep;
	if ($rep){
	    @rep = split(/,/, $rep);
	}
	else{
	    @rep = @validsearch_url;
	}
	$rep = 1;
	foreach $repnew(@rep) {
	    print "\n<br>\n<br>************************************<br>\nRepertoire $repnew (<i>indexation</i>)<br><br>\n"; ### debug
	    my(@DataDir,$data);
	    unless (($repnew) and (grep(/^$repnew$/, @validsearch_url))){
		$rep--;
		print "\n<br>\nRepertoire $repnew NON VALIDE<br>\n"; ### debug
	    }
	    else{
		$rep++;
		opendir (DIR, $repnew);
		@DataDir=grep(!/^\.\.?$|(.*)\.idx$|(.*)\.top$|(.*)\.lst$|(.*)\.dat$/, readdir DIR);
		close (DIR);
		@DataDir = sort {$b <=> $a} (@DataDir);
		open(DATASEARCH,">$repnew/$datasearch") || die $!;
		foreach $data(@DataDir) {
		    if ($debug){print "\n / $data\n";} ### debug
		    else{print " .";} ### debug
		    $data = dataindex($data,$repnew);
		    if ($data){
			print DATASEARCH "$data\n";
		    }
		}
		close(DATASEARCH);
		print "\n<br>\n / $repnew : <b>indexation complte</b>\n"; ### debug
	    }
	}
	if ($rep){
	    print "<br><br><br>Indexation : traitement termin.<br>\n";
	    if ($debug){print "Temps de traitement : ".(time()-$searchtime)." seconde(s)<br>\n";} ### debug
	}
	else{
	    print "<br><br><br>Indexation : aucun traitement.<br>\n";
	}
    }
    else{
	print "<br><br><br>Indexation : erreur d'identification.<br>\n";
    }
    if (!$debug){ print "</div>"; &pao_mini_bas; &foot_gen; }
    else{ print "<br>\n<br>\n$ver<br>\n<br>\n"; print "Temps de rponse : ".(time()-$searchtime)." seconde(s)<br>\n"; }
}

#######################################################################################################

sub dataprepare {
    my ($data,$DataFile,$repnew,$type,@DataFile) = @_;
    my @DataIdx =();
    if ($repnew eq $dir_txt){
	$data =~ s/\.txt//;
	$DataFile = join(' ', grep(!/^\!\!/, @DataFile));
#	$DataFile = join(' ', @DataFile);
	@DataFile = (); ## utilise maintenant @DataFile comme stockage temporaire
	open(DATAIDX, "$repnew/$data.idx");
	@DataFile = <DATAIDX>;
	close(DATAIDX);
	if (-e "$repnew/$data.lst"){ ## c'est une page index
	    unless ($filesindex{$data}=~/^_I_/){ ## non invisible
		push(@DataIdx, @DataFile[0]); # titre
		push(@DataIdx, "/"); # auteur
		push(@DataIdx, $DataFile); # texte
		@DataFile =(); ## le tableau  renvoyer
		push(@DataFile, "$site_url/resooindex.pl?$data"); ## le lien
		push(@DataFile, "@DataIdx[0]"); ## le titre
	    }
	}
	else{ ## c'est une page article
	    my $data2 = @DataFile[1];
	    chomp($data2);
	    unless ($filesindex{$data2}=~/^_I_/){ ## non invisible
		push(@DataIdx, @DataFile[0]); # titre
		push(@DataIdx, @DataFile[4]); # auteur
		push(@DataIdx, $DataFile); # texte
		@DataFile =(); ## le tableau  renvoyer
		push(@DataFile, "$site_url/resoopage.pl?$data"); ## le lien
		push(@DataFile, "@DataIdx[0]"); ## le titre
	    }
	}
    }
    elsif ($repnew eq $mesgdir){ ## c'est un message forum
	push(@DataIdx, @DataFile[5]); # titre
	push(@DataIdx, @DataFile[1]); # auteur
	push(@DataIdx, @DataFile[6]); # texte
	@DataFile =(); ## le tableau  renvoyer
	push(@DataFile, "$site_url/resoobbs.pl?$repnew/$data"); ## le lien
	push(@DataFile, $searchBBS[2].": ".@DataIdx[0]); ## le titre
    }
    foreach $DataFile(@DataIdx){
	$DataFile =~ s/<([^>]|\n)*>/ /g; ## formatage html
	$DataFile =~ s/[+\-\[\]()<>*]/ /g; ## formatage resoohtml
	$DataFile =~ s/\|\d\|/\|/g; ## spcifique resoolink
	$DataFile =~ s/\|/ /g; ## formatage resoohtml
	$DataFile =~ s/\'\'\'\'/ /g; ## formatage resoohtml (conserve ')
	$DataFile =~ s/\'\'\'/ /g; ## formatage resoohtml (conserve ')
	$DataFile =~ s/\'\'/ /g; ## formatage resoohtml (conserve ')
	$DataFile =~ s/\r|\n/ /g; ## formatage texte
	$DataFile =~ s/\s+/ /g; ## final
    }
    push(@DataFile, "$DataIdx[0] [ $DataIdx[1] ] $DataIdx[2]");
    if ($type eq "T"){
	$DataFile = "$DataIdx[0] [ $DataIdx[1] ]";
    }
    else{
	$DataFile = "$DataIdx[0] [ $DataIdx[1] ] $DataIdx[2]";
    }
    return($DataFile,@DataFile);
}

#######################################################################################################

sub dataindex {
    my ($data,$repnew) = @_;
    my @DataIdx =();
    my @DataFile =();
    my $DataFile ="";
    if ($repnew eq $dir_txt){
	$data =~ s/\.txt//;
	open(DATAIDX, "$repnew/$data.idx");
	@DataFile = <DATAIDX>;
	close(DATAIDX);
	if (-e "$repnew/$data.lst"){ ## c'est une page index
	    unless ($filesindex{$data}=~/^_I_/){ ## non invisible
		push(@DataIdx, "$data.txt"); ## la cl
		push(@DataIdx, "$site_url/resooindex.pl?$data"); ## le lien
		push(@DataIdx, @DataFile[0]); ## le titre
		push(@DataIdx, "-"); # auteur
		open(DATATXT, "$repnew/$data.txt");
		@DataFile = <DATATXT>;
		close(DATATXT);
#		$DataFile = join(' ', grep(!/^\!\!/, @DataFile));
		push(@DataIdx, $DataFile); # le texte
	    }
	}
	else{ ## c'est une page article
	    $DataFile = @DataFile[1];
	    chomp($DataFile);
	    unless ($filesindex{$DataFile}=~/^_I_/){ ## non invisible
		push(@DataIdx, "$data.txt"); ## la cl
		push(@DataIdx, "$site_url/resoopage.pl?$data"); ## le lien
		push(@DataIdx, @DataFile[0]); ## le titre
		if (@DataFile[4] ne "\n"){
		    push(@DataIdx, @DataFile[4]); # auteur
		}
		else{
		    push(@DataIdx, "-"); # auteur
		}
		open(DATATXT, "$repnew/$data.txt");
		@DataFile = <DATATXT>;
		close(DATATXT);
		$DataFile = join(' ', grep(!/^\!\!/, @DataFile));
		push(@DataIdx, $DataFile); # le texte
	    }
	}
    }
    elsif ($repnew eq $mesgdir){ ## c'est un message forum
	open(DATATXT, "$repnew/$data");
	@DataFile = <DATATXT>;
	close(DATATXT);
	push(@DataIdx, "$data"); ## la cl
	push(@DataIdx, "$site_url/resoobbs.pl?$repnew/$data"); ## le lien
	push(@DataIdx, $searchBBS[2].": ".@DataFile[5]); ## le titre
	push(@DataIdx, @DataFile[1]); # auteur
	push(@DataIdx, @DataFile[6]); # le texte
    }
    foreach $DataFile(@DataIdx){
	$DataFile =~ s/<([^>]|\n)*>/ /g; ## formatage html
	$DataFile =~ s/[_+\[\]\(\)<>\*]/ /g; ## formatage resoohtml
	$DataFile =~ s/\|\d\|/\|/g; ## spcifique resoolink
	$DataFile =~ s/\|/ /g; ## formatage resoohtml
	$DataFile =~ s/\'\'\'\'|\'\'\'|\'\'/ /g; ## formatage resoohtml (conserve ')
	$DataFile =~ s/\-\-\-\-|\-\-\-|\-\-/ /g; ## formatage resoohtml (conserve -)
	$DataFile =~ s/\r|\t/ /g; ## formatage texte
	$DataFile =~ s/\n//g; ## formatage texte
	$DataFile =~ s/\s+/ /g; ## final
    }
    $DataFile = join('][', @DataIdx);
    return($DataFile);
}

#######################################################################################################

sub dataindexprepare {
    my ($type,@DataIdx) = @_;
    my $DataFile ="";
    my @DataFile =();
    push(@DataFile, $DataIdx[1]);
    push(@DataFile, $DataIdx[2]);
    push(@DataFile, "$DataIdx[2] ($DataIdx[3]) $DataIdx[4]");
    if ($type eq "T"){
	$DataFile = "$DataIdx[2] ($DataIdx[3])";
    }
    else{
	$DataFile = "$DataIdx[2] ($DataIdx[3]) $DataIdx[4]";
    }
    if (!(@DataFile[0])){
	@DataFile = ();
	$DataFile = "";
    }
    return($DataFile,@DataFile);
}

#######################################################################################################

sub search_console{
## ($ARGV[0] eq "-s") { $action = 2; $type = $ARGV[1]; $rep = $ARGV[2]; $mot = $ARGV[3]; $meth = $ARGV[4]; $pagerep = $ARGV[5]; }
    my ($mot) = @_;
    $mot =~ s/,/ /g;
    print "<br>\n";
    print "
    <TABLE BORDER=0><TR><TD ALIGN=\"center\">\n
    <form method=\"GET\" action=\"./resoosearch.pl\">\n
    <i>Recherche</i>&nbsp\;
    <INPUT TYPE=hidden NAME=1 VALUE=\"$search_mode\">\n
    <i>sur</i>&nbsp\;:\n
    ";
    if($type eq "T"){
	print "
    <INPUT TYPE=radio NAME=2 VALUE=T CHECKED> titre seul\n
    <INPUT TYPE=radio NAME=2 VALUE=X> tout le document\n
    ";
    }
    else{
	print "
    <INPUT TYPE=radio NAME=2 VALUE=T> titre seul\n
    <INPUT TYPE=radio NAME=2 VALUE=X CHECKED> tout le document\n
    ";
    }
    if (@validsearch_url > 1){ ## la recherche peut porter sur plusieurs rpertoires
	my $validsearch_url = join(',', @validsearch_url);
	print "
    &nbsp\;&nbsp\;<i>dans</i>&nbsp\;:\n
    <SELECT NAME=3>\n
    ";
	if ($rep){ ## une recherche est en cours
	    foreach my $searchDIR(@validsearch){
		if ((@$searchDIR[0]) and (@$searchDIR[1] eq $rep)){
		    print "
    <OPTION VALUE=@$searchDIR[1] SELECTED>@$searchDIR[2]</OPTION>\n
    ";
		}
		elsif (@$searchDIR[0]){
		    print "
    <OPTION VALUE=@$searchDIR[1]>@$searchDIR[2]</OPTION>\n
    ";
		}
	    }
	    if ($validsearch_url eq $rep){
		print "
    <OPTION VALUE=$validsearch_url SELECTED>$searchTous</OPTION>\n
    ";
	    }
	    else{
		print "
    <OPTION VALUE=$validsearch_url>$searchTous</OPTION>\n
    ";
	    }
	}
	else{ ## premier affichage console
	    foreach my $searchDIR(@validsearch){
		if (@$searchDIR[0]){
		    print "
    <OPTION VALUE=@$searchDIR[1]>@$searchDIR[2]</OPTION>\n
    ";
		}
	    }
	    print "
    <OPTION VALUE=$validsearch_url>$searchTous</OPTION>\n
    </SELECT>\n
    ";
	}
    }
    else{ ## la recherche ne peut porter que sur 1 rpertoire
	print "
    <INPUT TYPE=hidden NAME=3 VALUE=\"$defaut_rep\">\n
    ";
    }
    print "
    </TD></TR><TR><TD ALIGN=\"center\">\n
    <INPUT TYPE=text NAME=4 SIZE=60 VALUE=\"$mot\">\n
    </TD></TR><TR><TD ALIGN=\"center\">\n
    <INPUT TYPE=submit VALUE=\"Lancer la recherche\">\n
    </TD></TR><TR><TD ALIGN=\"center\">\n
    <i>Correspondance</i>&nbsp\;:\n
    ";
    if($meth == 7){
	print "
    <INPUT TYPE=radio NAME=5 VALUE=7 CHECKED> phrase exacte&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=6> tous les mots&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=4> tendue\n
    ";
    }
    elsif($meth == 4){
	print "
    <INPUT TYPE=radio NAME=5 VALUE=7> phrase exacte&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=6> tous les mots&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=4 CHECKED> tendue\n
    ";
    }
    else{
	print "
    <INPUT TYPE=radio NAME=5 VALUE=7> phrase exacte&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=6 CHECKED> tous les mots&nbsp\;&nbsp\;&nbsp\;\n
    <INPUT TYPE=radio NAME=5 VALUE=4> tendue\n
    ";
    }
    print "
    &nbsp\;&nbsp\;\n
    </form>\n
    </TD></TR></TABLE>\n
    ";
}

#######################################################################################################

sub search_console2{ ## reprise de la configuration de recherche de l'utilisateur
    my ($mot) = @_;
    $mot =~ s/,/ /g;
    print "<br>\n";
    print "
    <TABLE BORDER=0><TR><TD>\n
    <form method=\"GET\" action=\"./resoosearch.pl\">\n
    <i>Recherche</i>&nbsp\;
    <INPUT TYPE=hidden NAME=1 VALUE=\"$search_mode\">\n
    <INPUT TYPE=hidden NAME=2 VALUE=\"$type\">\n
    <INPUT TYPE=hidden NAME=3 VALUE=\"$rep\">\n
    <INPUT TYPE=text NAME=4 SIZE=40 VALUE=\"$mot\">\n
    <INPUT TYPE=hidden NAME=5 VALUE=\"$meth\">\n
    &nbsp\;&nbsp\;\n
    <INPUT TYPE=submit VALUE=\"Rechercher\">\n
    </form>\n
    </TD></TR></TABLE>\n
    ";
}

#######################################################################################################

sub print_link{
    my (@DataFILE) = @_;
    if($debug){print "\n<br>----------------------------------------------\n";} ### debug
    print "<br><table width=600><tr><td BGCOLOR=\"$couleur_cad\">$font_cad";
    print "$DataFILE[3]";
    if ($usetitre){
	print " - <a href=\"$DataFILE[0]\"><big><strong>$DataFILE[1]</strong></big></a><br>\n";
    }
    else{
	print " - <a href=\"$DataFILE[0]\"><strong>$DataFILE[0]</strong></a><br>\n";
    }
    print "$font_cad$DataFILE[4]<br>$finfont\n";
    print "<font color=\"$coul_lien\">$DataFILE[0]</a></font><br>\n";
    print "$finfont</td></tr></table>\n";
}

##############################  THE  END  #############################################################

sub verify {
    my ($util,$pass) = @_;
   open(MAIN,"$private/$util.txt") || return 0;
   @main = <MAIN>;
      foreach $main_line (@main) {
	 $passcrypt = &resoocrypt($pass);
         if ($main_line =~ /^$passcrypt$/) {
            return 1;
         }
         else {
	     return 0;
         }
      }
   close(MAIN);
}
