#!/usr/bin/perl

#
#  REF: resooboardadmin.pl
#  ResooSite v.0.9.5 -(p)Resoo 2002-2003
#  (c)2003 - pascal blain / GNU GPL - General Public License
#  http://www.resoo.org/resoosite
#  pascal@resoo.org
#

require "resooconf.pl";
require "resoobbsconf.pl";

use CGI qw(:all); ## fonction "remote_host"

###########################################################################
# Subroutine

# Obtenir les informations du formulaire
	&parse_form;
# Mettre les champs dans des variables
	&get_variables;


###### cration de message
if (($action == 1) or ($action == 10)) {
    # Obtenir le nb de messages (data)
	&get_number;
	&get_date;
    # Ouvrir un nouveau fichier et y ecrire les infos
	&new_file;
    # Crer une balise topic s'il y a lieu
        &main_page;
    # Lier message et reponse s'il y a lieu
        &thread_pages;
    # Retourner une page HTML a l'utilisateur
	&return_html;
    # Incrementer le compteur
	&increment_num;
}

###### validation de message  partir d'un fichier temp
if (($action == 21) or ($action == 31)) {
    # Enregistre le fichier tmp modifi
	if ($action == 31) {
	    &modif_file;
	}
    # Obtenir les donnes du message tmp
	open(MESG,"$mesgdirtmp/$delfichier.$ext1") || &error(no_file_admin);
	@board = <MESG>;
	close(MESG);
	&get_mesg;
    # Obtenir le nb de messages (data)
	&get_number;
    # Ouvrir un nouveau fichier et y ecrire les infos
	&new_file;
    # Crer une balise topic s'il y a lieu
	&main_page;
    # Lier les messages et leurs reponses
	&thread_pages;
    # supprimer le fichier de validation (variable delfichier)
	&del_fichier;
    # Retourner une page HTML a l'utilisateur
	&return_html;
    # Incrementer le compteur
	&increment_num;
}

###### validation/edition/suppression de message (temp)
if (($action == 30) or ($action == 40)) {
    # Obtenir les donnes du fichier tmp ou du message
        if ($action == 30) {
	    open(MESG,"$mesgdirtmp/$delfichier.$ext1") || &error(no_file_admin);
	}
        if ($action == 40) {
	    open(MESG,"$mesgdir/$delfichier.$ext1") || &error(bad_file_admin);
	}
	@board = <MESG>;
	close(MESG);
	&get_mesg;
# Retourner une page HTML a l'utilisateur
	&return_html;
}

###### suppression de message
if (($action == 29) or ($action == 39)) {
    # supprimer le fichier de validation (variable delfichier)
	&del_fichier;
    # Retourner une page HTML a l'utilisateur
	&return_html;
}

###### edition/suppression de message
if ($action == 41) {
    # Enregistrer le fichier modifi
	&modif_file;
    # Retourner une page HTML a l'utilisateur
	&return_html;
}

###### suppression des donnes d'un message
if ($action == 42) {
    # Effacer le contenu d'un message
    if ($delfichier) {
	&eff_mesg($delfichier);
    }
    else {
	&error(no_topic_admin);
    }
    # Retourner une page HTML a l'utilisateur
	&return_html;
}

###### suppression de message ou de topic
if ($action == 48) {
    # supprimer le message et refaire les liens
    if ($delfichier) {
	&supp_mesg($delfichier);
    }
    else {
	&error(no_topic_admin);
    }
    # Retourner une page HTML a l'utilisateur
	&return_html;
}

###### suppression de fil de discussion
if ($action == 49) {
    # Supprimer un topic
    if ($deltopic) {
#	print "Content-type: text/html\n\n";  ### debug
#	print "procdure supp_topic:<br><br>";  ### debug
	&del_topic($deltopic);
	&supp_topic($deltopic);
    }
    else {
	&error(bad_file_admin);
    }
    # Retourner une page HTML a l'utilisateur
	&return_html;
}

###### affichage du log des messages
if (($action == 50) or ($action == 52)) {
    # Affichage
	&page_admin;
}

###### suppression (multiple) de fil de discussion
if ($action == 59) {
    # Supprimer un topic
    if (@del_topics) {
#	print "Content-type: text/html\n\n";  ### debug
#	print "procdure supp_topic:<br><br>";  ### debug
	foreach $deltopic(@del_topics) {
#		print "$deltopic<br>";  ### debug
		&del_topic($deltopic);
		&supp_topic($deltopic);
	}
    }
    # Retourner une page HTML a l'utilisateur
    &page_admin;
}


########################################
# Obtenir le nb de messages - Subroutine

sub get_number {
   my $wfile = "$dir_bbs/$datafile";
   if (!(-e $wfile)){open(NEW,"> $wfile");print NEW "0";close(NEW); }
   open(NUMBER,"$wfile") || die $!;;
   $num = <NUMBER>;
   close(NUMBER);
   if ($num == 999999)  {
      $num = "1";
   }
   else {
      $num++;
   }
}

#####################################################
# Obtenir les informations du formulaire - Subroutine

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if ($allow_html != 1) {
         $value =~ s/<([^>]|\n)*>//g;
      }
      else {
         unless ($name eq 'bbsbodymess') {
	    $value =~ s/<([^>]|\n)*>//g;
         }
      }

      if ($name eq "del_topics") {
	    push (@del_topics,$value);
      }

      $FORM{$name} = $value;
   }

}

###################################################
# Mettre les champs dans des variables - Subroutine

sub get_variables {

    if ($FORM{'action'}) {
	$action = "$FORM{'action'}";
    }
    else {
        $action = "";
    }

    if ($FORM{'nummesg'}) {
	$nummesg = "$FORM{'nummesg'}";
    }

    if ($FORM{'orignum'}) {
        $orignum = "$FORM{'orignum'}";
    }
    else {
        $orignum = "";
    }

    if ($FORM{'num'}) {
        $num = "$FORM{'num'}";
    }
    else {
        $num = "";
    }

    if ($FORM{'delfichier'}) {
        $delfichier = "$FORM{'delfichier'}";
    }
    else {
        $delfichier = "";
    }

    unless ((!$moderation) and (($action == 1) or ($action == 10))) {

	if ($FORM{'verif'}) {
    	    $verif = "$FORM{'verif'}";
	}
	else {
    	    $verif = "0"
	}

	if ($FORM{'util'}) {
    	    $util = "$FORM{'util'}";
		if ($FORM{'pass'}) {
		    $pass = "$FORM{'pass'}";
		    &verify;
		}
	    else {
		$verif = ( $verif + 1 );
		&page_verify;
	    }
	}
	else {
	    &page_verify;
	}
    }

    if (($action == 1) or ($action == 10)) {
 
	if ($FORM{'bbsname'}) {
	    $bbsname = "$FORM{'bbsname'}";
	    $bbsname =~ s/\"//g;
	    $bbsname =~ s/<//g;
	    $bbsname =~ s/>//g;
	    $bbsname =~ s/\&//g;
	    chomp($bbsname);
	    $bbsname =~ s/\r//g;
	    $bbsname =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_name_admin);
	}

	if ($FORM{'bbsemail'} =~ /.*\@.*\..*/) {
	    $bbsemail = "$FORM{'bbsemail'}";
	}

	if ($FORM{'bbssubject'}) {
	    $bbssubject = "$FORM{'bbssubject'}";
	    $bbssubject =~ s/\&/\&amp\;/g;
	    $bbssubject =~ s/\"/\&quot\;/g;
	    $bbssubject = lc($bbssubject);
	    chomp($bbssubject);
	    $bbssubject =~ s/\r//g;
	    $bbssubject =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_subject_admin);
	}

	if ($FORM{'message_url'} =~ /.*\:.*\..*/ && $FORM{'message_url_title'}) {
    	    $message_url = "$FORM{'message_url'}";
    	    chomp($message_url);
	    $message_url =~ s/\r//g;
	    $message_url =~ s/\n/ /g;
	    $message_url_title = "$FORM{'message_url_title'}";
    	    chomp($message_url_title);
	    $message_url_title =~ s/\r//g;
	    $message_url_title =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}

	if ($FORM{'img'} =~ /.*tp:\/\/.*\..*/) {
    	    $message_img = "$FORM{'img'}";
    	    chomp($message_img);
	    $message_img =~ s/\r//g;
	    $message_img =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}

	if ($FORM{'bbsbodymess'}) {
	    $bbsbodymess = "$FORM{'bbsbodymess'}";
	    $bbsbodymess =~ s/\cM//g;
	    $bbsbodymess =~ s/\n\n/<p>/g;
	    $bbsbodymess =~ s/\n/<br>/g;

	    $bbsbodymess =~ s/&lt;/</g; 
	    $bbsbodymess =~ s/&gt;/>/g; 
	    $bbsbodymess =~ s/&quot;/\"/g;
	    $renew = $bbsbodymess;
	    &unword;
	    $bbsbodymess = $renew;
	}
	else {
	    &error(no_body_admin);
	}

    }

####    if ($action == 21)

####    if ($action == 29)

####    if ($action == 30)

    if ($action == 31) {

	if ($FORM{'bbsname'}) {
	    $bbsname = "$FORM{'bbsname'}";
	    $bbsname =~ s/\"//g;
	    $bbsname =~ s/<//g;
	    $bbsname =~ s/>//g;
	    $bbsname =~ s/\&//g;
	    chomp($bbsname);
	    $bbsname =~ s/\r//g;
	    $bbsname =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_other);
	}

	if ($FORM{'bbsemail'} =~ /.*\@.*\..*/) {
	    $bbsemail = "$FORM{'bbsemail'}";
	}

	if ($FORM{'bbssubject'}) {
	    $bbssubject = "$FORM{'bbssubject'}";
	    $bbssubject =~ s/\&/\&amp\;/g;
	    $bbssubject =~ s/\"/\&quot\;/g;
	    $bbssubject = lc($bbssubject);
	    chomp($bbssubject);
	    $bbssubject =~ s/\r//g;
	    $bbssubject =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_other);
	}

	if ($FORM{'bbsbodymess'}) {
	    $bbsbodymess = "$FORM{'bbsbodymess'}";
	    $bbsbodymess =~ s/\cM//g;
	    $bbsbodymess =~ s/\n\n/<p>/g;
	    $bbsbodymess =~ s/\n/<br>/g;

	    $bbsbodymess =~ s/&lt;/</g; 
	    $bbsbodymess =~ s/&gt;/>/g; 
	    $bbsbodymess =~ s/&quot;/\"/g;
	    $renew = $bbsbodymess;
	    &unword;
	    $bbsbodymess = $renew;
	}
	else {
	    &error(no_other);
	}

    }

####    if ($action == 39)

    if ($action == 41) {

	if ($FORM{'delfichier'}) {
    	    $delfichier = "$FORM{'delfichier'}";
	}

	if ($FORM{'bbsname'}) {
	    $bbsname = "$FORM{'bbsname'}";
	    $bbsname =~ s/\"//g;
	    $bbsname =~ s/<//g;
	    $bbsname =~ s/>//g;
	    $bbsname =~ s/\&//g;
	    chomp($bbsname);
	    $bbsname =~ s/\r//g;
	    $bbsname =~ s/\n/ /g;
	##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_other_admin);
	}

	if ($FORM{'bbsemail'} =~ /.*\@.*\..*/) {
	    $bbsemail = "$FORM{'bbsemail'}";
	}

	if ($FORM{'bbssubject'}) {
	    $bbssubject = "$FORM{'bbssubject'}";
	    $bbssubject =~ s/\&/\&amp\;/g;
	    $bbssubject =~ s/\"/\&quot\;/g;
	    $bbssubject = lc($bbssubject);
	    chomp($bbssubject);
	    $bbssubject =~ s/\r//g;
	    $bbssubject =~ s/\n/ /g;
	    ##### a voir: controle du nombre de caractres
	}
	else {
	    &error(no_other_admin);
	}

	if ($FORM{'bbsbodymess'}) {
	    $bbsbodymess = "$FORM{'bbsbodymess'}";
	    $bbsbodymess =~ s/\cM//g;
	    $bbsbodymess =~ s/\n\n/<p>/g;
	    $bbsbodymess =~ s/\n/<br>/g;

	    $bbsbodymess =~ s/&lt;/</g; 
	    $bbsbodymess =~ s/&gt;/>/g; 
	    $bbsbodymess =~ s/&quot;/\"/g;
	    $renew = $bbsbodymess;
	    &unword;
	    $bbsbodymess = $renew;
	}
	else {
	    &error(no_other_admin);
	}

    }

####    if ($action == 42)

####    if ($action == 48)

    if ($action == 49) {

	if ($FORM{'deltopic'}) {
	    $deltopic = "$FORM{'deltopic'}";
	}
	else {
	    $deltopic = "0";
	}

    }

####    if ($action == 50)

####    if ($action == 52)

####    if ($action == 59)  voir parse_form pour la cration du tableau (@del_topics,$value)

}      

##############################################################
# supprimer le fichier de validation - Subroutine

sub del_fichier {

    if (($action == 29) or ($action == 21) or ($action == 31) or ($action == 39)) {
	my $wfile = "$mesgdirtmp/$delfichier.$ext1";
        unlink ($wfile);
    }
}


##############################################################
# supprimer un message - Subroutine

sub eff_mesg {
    $file = $_[0];
    my $mfile = "$mesgdir/$file.$ext1";
    open(EFFFILE,"$mfile") || &error(bad_file_admin);
    @efffile = <EFFFILE>;
    close(EFFFILE);
    $oldbbsip = @efffile[0];
    $oldbbsip =~ s/\n//;
    @efffile[0] = "$oldbbsip [EFF: $util] ".remote_host."\n";
    @efffile[1] = "$bbsname_mod\n";
    @efffile[2] = "$email_mod\n";
    @efffile[5] = "$bbssubject_eff\n";
    @efffile[6] = "$bbsbodymess_eff ($email_mod)\n";
    open(NEWFILE,">$mfile") || &error(no_perm);
    foreach $line(@efffile) {
	print NEWFILE "$line";
    }
    close(NEWFILE);
}


##############################################################
# supprimer un message - Subroutine

sub supp_mesg {
    $file = $_[0];
    my $mfile = "$mesgdir/$file.$ext1";
    open(SUPFILE,"$mfile") || &error(bad_file_admin);
    @board = <SUPFILE>;
    close(SUPFILE);
    &get_mesg;
    if ($num_followup) { ## s'il y a des des rponses
	foreach $mod_reponse(@followups) { # je modifie le "orignum" des rponses
	    my $wfile = "$mesgdir/$mod_reponse.$ext1";
	    open(MODFILE,"$wfile") || &error(bad_file_admin);
	    @modfile = <MODFILE>;
	    close(MODFILE);
	    @modfile[9] = "$orignum\n";
	    open(NEWFILE,">$wfile") || &error(no_perm);
	    foreach $line(@modfile) {
	        print NEWFILE "$line";
	    }
	    close(NEWFILE);
	    if (!$orignum) { ## si c'est un topic, je cre de nouveaux topics
    		my $wfile = "$mesgdir/$mod_reponse.$ext2";
    		open(MAIN,">$wfile") || &error(no_perm);
    		@main = <MAIN>;
    		print MAIN "1";
    		close(MAIN);
	    }
	}
    }
    if ($orignum) { ## si c'est une rponse
	my $wfile = "$mesgdir/$orignum.$ext1"; # je modifie le "followup" du fichier prcdent
	open(MODFILE,"$wfile") || &error(bad_file_admin);
	@modfile = <MODFILE>;
	close(MODFILE);
	if ($follow_up) {
	    @modfile[8] =~ s/\|$num\|/\|$follow_up\|/;
	}
	else {
	    @modfile[8] =~ s/\|$num\|/\|/;
	}
	open(NEWFILE,">$wfile") || &error(no_perm);
	foreach $line(@modfile) {
    	    print NEWFILE "$line";
	}
	close(NEWFILE);
    }
    else { ## sinon c'est un topic, et je supprime le fichier topic
	unlink("$mesgdir/$file.$ext2");
    }
    unlink($mfile); ## je termine en supprimant le fichier message
}


##############################################################
# supprimer le topic et toutes ses rponses - Subroutine

sub verif_topic {
    $file = $_[0];
    my $mfile = "$mesgdir/$file.$ext2";
    if (!(-s $mfile)) {
	&error(no_topic_admin);
    }
}

sub del_topic {
    $file = $_[0];
    my $mfile = "$mesgdir/$file.$ext2";
    if (!(-s $mfile)) {
	&error(no_topic_admin);
    }
    else {
	unlink($mfile);
    }
}

sub supp_topic {
    $file = $_[0];
    my $mfile = "$mesgdir/$file.$ext1";
    open(FILE,"$mfile");
    @file = <FILE>;
    close(FILE);
    $followup = @file[8];
    $followup =~ s/^\|//;
    $followup =~ s/\|$//;
    $followup =~ s/\n//;
    while ($followup) {
	my @followups = split(/\|/,$followup);
	foreach $delfile(@followups) {
	&supp_topic($delfile);
	}
    }
	unlink($mfile);
#	print "unlink : $mfile<br>\n"; #### debug
}


##############################################################
# Ouvrir un nouveau fichier et y ecrire les infos - Subroutine

sub new_file {

    my $wfile = "$mesgdir/$num\.$ext1";
    open(NEWFILE,">$wfile") || die $!;
    if ($action == 1){ ## pas de modration
        print NEWFILE remote_host."\n";
    }
    elsif ($action == 10) { ## pas de modration (action admin)
        print NEWFILE remote_host." [$util]\n";
    }
    elsif ($action == 31) { ## la modif est dj logue par modif_file
        print NEWFILE "$bbsip\n";
    }
    else { ## modration
	print NEWFILE "$bbsip [$util] ".remote_host."\n";
    }
    print NEWFILE "$bbsname\n";
    print NEWFILE "$bbsemail\n";
    if (($action == 1) or ($action == 10)) {
    print NEWFILE "$date\n";
    print NEWFILE "$heure\n";
    }
    else {
	print NEWFILE "$bbsdate\n";
	print NEWFILE "$bbsheure\n";
    }
    print NEWFILE "$bbssubject\n";
    print NEWFILE "$bbsbodymess\n";
    print NEWFILE "$num\n"; ## le numro du message
    print NEWFILE "|\n";
    print NEWFILE "$orignum\n";
    print NEWFILE "$message_img\n";
    print NEWFILE "$message_url\n";
    print NEWFILE "$message_url_title\n";
    close(NEWFILE);
}

##############################################################
# Modifier un fichier temporaire avant validation - Subroutine

sub modif_file {

    if ($action == 31) {
	$wfile = "$mesgdirtmp/$delfichier.$ext1";
    }
    if ($action == 41) {
	$wfile = "$mesgdir/$delfichier.$ext1";
    }
    open(MODFILE,"$wfile") || &error(no_file_admin);
    @modfile = <MODFILE>;
    close(MODFILE);
    $oldbbsip = @modfile[0];
    $oldbbsip =~ s/\n//;
    if ($action == 31) {
	@modfile[0] = "$oldbbsip [MODER: $util] ".remote_host."\n";
    }
    elsif ($action == 41) {
	@modfile[0] = "$oldbbsip [MODIF: $util] ".remote_host."\n";
    }
    else {
	@modfile[0] = "$oldbbsip [---: $util] ".remote_host."\n";
    }
    @modfile[1] = "$bbsname\n";
    @modfile[2] = "$bbsemail\n";
    @modfile[5] = "$bbssubject\n";
    @modfile[6] = "$bbsbodymess\n";
    open(NEWFILE,">$wfile") || &error(no_perm);
    foreach $line(@modfile) {
	print NEWFILE "$line";
    }
    close(NEWFILE);
}

#############################################################
# Ouvrir le fichier principal et ajouter un lien - Subroutine

sub main_page {

   if (!$orignum) {
        my $wfile = "$mesgdir/$num\.$ext2";
        open(MAIN,">$wfile") || &error(no_perm);
        @main = <MAIN>;
        print MAIN "1";
        close(MAIN);
   }
}

######################################################
# Lier le message  son message d'origine - Subroutine

sub thread_pages {

    if ($orignum) {
        my $wfile = "$mesgdir/$orignum\.$ext1";
	open(MODFILE,"$wfile") || &error(no_file);
	@modfile = <MODFILE>;
	close(MODFILE);
	my $followup = @modfile[8];
	$followup =~ s/\n//;
	@modfile[8] = "$followup$num|\n";
	open(NEWFILE,">$wfile") || &error(no_perm);
	foreach $line(@modfile) {
	    print NEWFILE "$line";
        }
	close(NEWFILE);
    }
}

######################################################
# Retourner une page HTML a l'utilisateur - Subroutine

sub return_html {

    print "Content-type: text/html\; charset=ISO-8859-1\n\n";
    
    &head_bbs;

    print "<table border=\"0\" width=\"600\">\n";
    print "<tr>\n";
    print "<td width=\"600\" colspan=\"3\">\n";
    print "$font\n";
	if (($action == 1) or ($action == 10) or ($action == 21) or ($action == 31)) {
	    print "<center><h2>Message envoy: $bbssubject</h2></center>\n";
	    print "Les informations suivantes ont t ajoutes au site:<p><hr size=7 width=75%><p>\n";
	    print "<u>Nom:</u>$fontbbs $bbsname $finfontbbs<br>\n";
	    if ($bbsemail) {
		print "<u>E-Mail:</u>$fontbbs $bbsemail $finfontbbs<br>\n";
	    }
	    print "<u>Titre:</u>$fontbbs $bbssubject $finfontbbs<br>\n";
	    print "<u>Message:</u><p>\n";
	    print "<UL>$fontbbs $bbsbodymess $finfontbbs</UL><p>\n";
	    if ($bbsdate) {
		print "<u>Ajout le:</u>$fontbbs $bbsdate $finfontbbs<p>\n";
	    }
	    else {
		print "<u>Ajout le:</u>$fontbbs $date $finfontbbs<p>\n";
	    }
	}
	if ($action == 30) {
	   print "<center><h2>Modration: $delfichier</h2></center>\n";
           &rest_of_form_admin1;
	}
	if ($action == 40) {
	   print "<center><h2>Modification: $delfichier</h2></center>\n";
           &rest_of_form_admin1;
	}
	if ($action == 41) {
	   print "<center><h2>Message modifi: $delfichier</h2></center>\n";
	}
	if (($action == 29) or ($action == 39)) {
	   print "<center><h2>Message supprim: $delfichier</h2></center>\n";
	}
	if ($action == 42) {
	   print "<center><h2>Message effac: $delfichier</h2></center>\n";
	}
	if ($action == 48) {
	   print "<center><h2>Message supprim: $delfichier</h2></center>\n";
	}
	if ($action == 49) {
	   print "<center><h2>Message supprim: $deltopic</h2></center>\n";
	}

    print "<hr size=7 width=75%>\n";
    print "<center>";

    if (($action == 41) or ($action == 42) or ($action == 48) or ($action == 49)) {
	&retourbbsadminlist;
    }

    if (($moderation) or ($util)) {
	&retourbbsadmin;
    }

    print "[ <a href=\"resoobbs.pl\"><b>Retour $forumtitre</b></a> ]</center>\n";
    print "$finfont\n";
    print "</td>\n";
    print "</tr>\n";
    print "</table>\n";
    
    &foot_gen;
}

######################################
# Incrementer le compteur - Subroutine

sub increment_num {
   open(NUM,">$dir_bbs/$datafile") || die $!;
   print NUM "$num";
   close(NUM);
}

####################################
######## vue administrateur ########

######## entete et pied de page ########

sub page_tete {

	print "Content-type: text/html\; charset=ISO-8859-1\n\n";

	&head;

	print "<table border=\"0\" width=\"600\">\n";
	print "<tr>\n";
	print "<td width=\"600\" colspan=\"3\">\n";
	print "$font\n";
	print "<div align=\"right\"><A HREF=\"$bbslink\"><B>Retour $forumtitre</B></A></div>\n";
	print "<br>\n";
	print "$fonttitre\n";
	if ( $verif == 9 ) {
		if ($action == 59) {
			print "Vue liste suppression/archivage\n";
		}
		elsif ($action == 52) {
			print "Vue liste suppression/dition\n";
		}
		elsif ($action == 50) {
			print "Vue liste log\n";
		}
		else {
			print "Page Administration $forumtitre\n";
		}
	}
	else {
		print "Saisie du mot de passe $fontstitre(modrateur)$finfontstitre\n";
	}
	print "$finfonttitre<br><hr>\n";
	print "Si vous avez un problme avec cette page, merci d'en informer ";
	print "<a href=\"mailto:$admin\">l'administrateur</a> de ce site<br>\n";
	print "$finfont\n";
	print "</td>\n";
	print "</tr>\n";
	print "<tr>\n";
	print "<td colspan=\"3\" width=\"600\" bgcolor=\"$couleur_cell\" align=\"right\">\n";
	print "$font\n";
	print "\&nbsp\;<br>\&nbsp\;\n";
	print "$finfont\n";
	print "</td>\n";
	print "</tr>\n";

	print "<tr>\n";
	print "<td colspan=\"3\" width=\"600\" align=\"center\" valign=\"TOP\">\n";
	print "$font \&nbsp\;<br>\n";
}


sub page_pied {

	print "$finfont\n";
	print "</td>\n";
	print "</tr>\n";
	print "<tr>\n";
	print "<td width=\"600\" colspan=\"3\">\n";
	print "$font\n";
	print "<div align=\"right\"><A HREF=\"$bbslink\"><B>Retour $forumtitre</B></A></div>\n";
	print "</td>\n";
	print "</tr>\n";

	print "</table>\n";

	&foot;
}

### page index administrateur

sub page_admin {

   &page_tete;
    if (!$action) {
	open (MAXNUM, "$dir_bbs/$datafiletmp");
    }
    else {
	open (MAXNUM, "$dir_bbs/$datafile");
    }
    @maxnum = <MAXNUM>;
    close (MAXNUM);
    $maxnum = @maxnum[0];
    print "<center><hr size=7 width=75\%></center>\n";
    if ($action == 59) {
    #### affichage de la liste topic en mode suppression
	&retourbbsadmin;
        print "<hr size=7 width=75\%></center>\n";
        print "<div align=left>\n";
	if (!$nummesg) {
	    $nummesg = $maxnum;
	}
	$defautnum = $defautnummesg;
	print "<form method=POST action=\"resooboardadmin.pl\">\n";
	for ($c = $nummesg ; $c > $nummesg-$defautnum ; $c--){
	    if (-s "$mesgdir/$c.$ext2") {
    		open (MESG, "$mesgdir/$c.$ext1");
    		@board = <MESG>;
    		close (MESG);
		&get_mesg;
		print "<table width=100% border=1><tr><td width=90%>";
		print "$font [$num] <b>$bbsname</b> - <i>$bbsdate - $bbsheure</i><br>  titre : <b>$bbssubject<b><br>$finfont";
		print "</td><td width=10%>";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=CHECKBOX name=\"del_topics\" value=\"$num\">\n";
		print "</TABLE></CENTER>\n";
		print "</td></tr></table>";
	    }
	    else { ## rajoute une itration
		if ($nummesg-$defautnum > 0) {
		    $defautnum++;
		}
	    }
	}
	print "<CENTER><TABLE BORDER=0>\n";
	print "<input type=hidden name=\"nummesg\" value=\"$nummesg\">\n";
	print "<input type=hidden name=\"util\" value=\"$util\">\n";
	print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
	print "<input type=hidden name=\"action\" value=\"59\">\n";
	print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" T_SUP - Supprimer les sujets selectionns  \"></TD></TR>\n";
	print "</TABLE></CENTER>\n";
	print "</form>\n";
    }
    elsif ($action == 52) {
	&retourbbsadmin;
        print "<hr size=7 width=75\%></center>\n";
        print "<div align=left>\n";
	if (!$nummesg) {
	    $nummesg = $maxnum;
	}
	$defautnum = $defautnummesg;
	for ($c = $nummesg ; $c > $nummesg-$defautnum ; $c--){
	    if (-s "$mesgdir/$c.$ext1") {
    		open (MESG, "$mesgdir/$c.$ext1");
    		@board = <MESG>;
    		close (MESG);
		&get_mesg;
		print "<table width=100% border=1><tr><td width=60%>";
		print "$font [$num] <b>$bbsname</b> - <i>$bbsdate - $bbsheure</i><br>  titre : <b>$bbssubject<b><br>$finfont";
		print "</td><td width=10%>";
		
		if (-s "$mesgdir/$c.$ext2") {
		    print "<form method=POST action=\"resooboardadmin.pl\">\n";
		    print "<CENTER><TABLE BORDER=0>\n";
		    print "<input type=hidden name=\"deltopic\" value=\"$num\">\n";
		    print "<input type=hidden name=\"util\" value=\"$util\">\n";
		    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		    print "<input type=hidden name=\"action\" value=\"49\">\n";
		    print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" T_SUP \"></TD></TR>\n";
		    print "</TABLE></CENTER>\n";
		    print "</form>\n";
		}
		else {
		    print " - ";
		}
		
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"48\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" SUPP \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"42\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" EFF \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"40\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" EDIT \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		print "</td></tr></table>";
	    }
	    else { ## rajoute une itration
		if ($nummesg-$defautnum > 0) {
		    $defautnum++;
		}
	    }
	}
    }    
    elsif ($action == 50) {
	&retourbbsadmin;
        print "<hr size=7 width=75\%></center>\n";
        print "<div align=left>\n";
	if (!$nummesg) {
	    $nummesg = $maxnum;
	}
	$defautnum = $defautnummesg;
	for ($c = $nummesg ; $c > $nummesg-$defautnum ; $c--){
	    if (-s "$mesgdir/$c.$ext1") {
    		open (MESG, "$mesgdir/$c.$ext1");
    		@board = <MESG>;
    		close (MESG);
		&get_mesg;
		print "<table width=100% border=1><tr><td width=100%>";
		print "$font Message # [$num] $bbsip<br> <b>$bbsname</b> - <i>$bbsdate - $bbsheure</i><br>  titre : <b>$bbssubject<b><br>$finfont";
		print "</td></tr></table>";
	    }
	    else { ## rajoute une itration
		if ($nummesg-$defautnum > 0) {
		    $defautnum++;
		}
	    }
	}
    }    
    else {
        print "<center>\[ <a href=\"\#post\"><B>Envoyer un message</B></a> \]";
        print " \[ <a href=\"#console\"><B>Console Admin</B></a> \]";
        print " \[ <a href=\"resoobbs.pl\"><B>Retour $forumtitre</B></a> \]\n";
        print "<hr size=7 width=75\%></center>\n";
        print "<div align=left>\n";
	if (!$nummesg) {
	    $nummesg = $maxnum;
	}
	$vide = 0;
	$defautnum = $defautnummesg;
	for ($c = $nummesg ; $c > $nummesg-$defautnum ; $c--){
	    if (-s "$mesgdirtmp/$c.$ext1") {
    		open (MESG, "$mesgdirtmp/$c.$ext1");
    		@board = <MESG>;
    		close (MESG);
		&get_mesg;
		print "<table width=100% border=1><tr><td width=70%>";
		print "$font [$bbsip] - <b>$bbsname</b> - <i>$bbsdate - $bbsheure</i><br>  titre : <b>$bbssubject<b>$finfont";
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"29\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" SUPP \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"orignum\" value=\"$orignum\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"21\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" *OK* \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		
		print "</td><td width=10%>";
		
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<input type=hidden name=\"delfichier\" value=\"$num\">\n";
		print "<input type=hidden name=\"orignum\" value=\"$orignum\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<input type=hidden name=\"action\" value=\"30\">\n";
		print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" EDIT \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";
		
		print "</td></tr></table>";
		
		$vide++;
	    }
	    else { ## rajoute une itration
		if ($nummesg-$defautnum > 0) {
		    $defautnum++;
		}
	    }
	}
        if (!$vide) {
	    if ($moderation) {
		print "<center>Aucun message en attente de modration.</center>\n";
	    }
	    else {
		print "<center>Le mode \"modration\" est dsactiv.</center>\n";
	    }
	}
    }
    print "</div>\n";
    print "<center>";
    print "<hr size=7 width=75\%>\n";
    print "<table width=75\% border=0><tr>\n";
    print "<td align=center>\n";
    if (!$action) {
	$mesg_dir = $mesgdirtmp;
    }
    else {
	$mesg_dir = $mesgdir;
    }
    $boucle = 0;
    for ($d = $c ; $d > 0 ; $d--){
	if (!$boucle){
	    if (-s "$mesg_dir/$d.$ext1") {
	    	$nummesgprec = $d;
		$boucle = 1;
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<input type=hidden name=\"nummesg\" value=\"$nummesgprec\">\n";
		print "<input type=hidden name=\"action\" value=\"$action\">\n";
		print "<input type=hidden name=\"util\" value=\"$util\">\n";
		print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
		print "<INPUT TYPE=SUBMIT VALUE=\"   page prddente   \">\n";
		print "</form>\n";
	    }
	}
    }
    if (!$nummesgprec) {print "$font  [ Pas de page prddente ]  $finfont\n";}
    print "</td><td align=center>\n";
    $boucle = 0;
    while ($boucle < $defautnummesg){
    	for ($d = $nummesg+1 ; $d < $maxnum+1 ; $d++){
	    if ($boucle < $defautnummesg){
		if (-s "$mesg_dir/$d.$ext1") {
	    	    $nummesgsuiv = $d;
		    $boucle++;
		}
	    }
	}
        $boucle = $defautnummesg;
    }
    if ($nummesgsuiv) {
	print "<form method=POST action=\"resooboardadmin.pl\">\n";
	print "<input type=hidden name=\"nummesg\" value=\"$nummesgsuiv\">\n";
	print "<input type=hidden name=\"action\" value=\"$action\">\n";
	print "<input type=hidden name=\"util\" value=\"$util\">\n";
	print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
	print "<INPUT TYPE=SUBMIT VALUE=\"   page suivante   \">\n";
	print "</form>\n";
    }
    else {print "$font  [ Pas de page suivante ]  $finfont\n";}

    print "</td>\n";
    print "</tr></table>\n";
    print "</center>";

    if (!$action) {
        print "<center><hr size=7 width=75\%><br>\n";
	print "$fontstitre <a name=console>Console Admin ($forumtitre)</a> $finfontstitre</center><br>\n";
	&consolebbs;

	print "<center><a name=post><hr size=7 width=75\%></a><br>\n";
	print "$fontstitre Envoyer un message (direct) $finfontstitre</center><br>\n";
	&rest_of_form_admin;

	print "<center><hr size=7 width=75\%>\n";
	print "\[ <a href=\"\#post\"><B>Envoyer un message</B></a> \]";
	print " \[ <a href=\"#console\"><B>Console Admin</B></a> \]";
	print " \[ <a href=\"resoobbs.pl\"><B>Retour $forumtitre</B></a> \]\n";
    }
    else {
        print "<center><hr size=7 width=75\%></center><br>\n";
	&retourbbsadmin;
    }

    print "<hr size=7 width=75\%></center>\n";


    &page_pied;
}


######## affichage page mot de passe ########

sub page_verify {

   &page_tete;

	if ($verif == 2) {
		print "$fontgrande\n";
		print "Votre mot de passe n'est pas valide,<br>\n";
		print "merci de contacter \n";
		print "<a href=\"mailto:$admin\">l'administrateur</a> du site $dir.<br>\n";
		print "$finfontgrande\n";
	}
	else {
		print "<form method=POST action=\"resooboardadmin.pl\">\n";
		print "<CENTER><TABLE BORDER=0>\n";
		print "<TR><TD>$font Utilisateur: $finfont</TD><TD> <INPUT TYPE=TEXT NAME=\"util\" SIZE=50></TD></TR>\n";
		print "<TR><TD>$font Mot de passe: $finfont</TD><TD> <INPUT TYPE=password NAME=\"pass\" SIZE=50></TD></TR>\n";
		print "<input type=hidden name=\"verif\" value=\"$verif\">\n";
		print "<TR><TD COLSPAN=2 ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" Valider \"> <INPUT TYPE=RESET VALUE=\" Annuler \"></TD></TR>\n";
		print "</TABLE></CENTER>\n";
		print "</form>\n";

		if ($verif == 1) {
			print "<br>\n";
			print "$fontstitre\n";
			print "deuxime essai\n";
			print "$finfontstitre\n";
		}
		else {
			print "<br>\n";
			print "$fontpetite\n";
			print "premier essai\n";
			print "$finfontpetite\n";
		}

		print "<hr>";
		print "<A HREF=\"resooadmin.pl\"><B>Accs au mode Super-Administrateur... cliquez ici!</B></A>\n";
		print "<hr>\n";
	}

   &page_pied;
}


######## verification mot de passe ########

sub verify {
    if (open (F, "$private/$util.bbs")) {
	open(MAIN,"$private/$util.bbs");
	@main = <MAIN>;
	foreach $main_line (@main) {
	    $passcrypt = &resoocrypt($pass);
    	    if ($main_line =~ /^$passcrypt$/) {
        	if (!$action) {
		    $verif = "9"; #condition du titre page_admin
		    $action = "0";
         	    &page_admin;
        	}
		else {
		    $verif = "9";
		}
    	    }
    	    else {
		&erreurpass;
    	    }
	}
	close(MAIN);
    }
    else {
	if (open (F, "$private/$util.txt")) {
	    open(MAIN,"$private/$util.txt");
	    @main = <MAIN>;
	    foreach $main_line (@main) {
		$passcrypt = &resoocrypt($pass);
    		if ($main_line =~ /^$passcrypt$/) {
        	    if (!$action) {
			$verif = "9"; #condition du titre page_admin
			$action = "0";
         		&page_admin;
        	    }
		    else {
			$verif = "9";
		    }
    		}
    		else {
		    &erreurpass;
    		}
	    }
	    close(MAIN);
	}
	else {
	    &erreurpass;
	}
    }
}

sub erreurpass {
	$action = 0;
	$verif = ( $verif + 1 );
	&page_verify;
}

######## bouton retour page admin bbs ########

sub retourbbsadmin {
	print "<form method=POST action=\"resooboardadmin.pl\">\n";
	print "<CENTER><TABLE BORDER=0>\n";
	print "<input type=hidden name=\"util\" value=\"$util\">\n";
	print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
	print "<input type=hidden name=\"action\" value=\"\">\n";
	print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\"   retour page Administrateur $forumtitre   \"></TD></TR>\n";
	print "</TABLE></CENTER>\n";
	print "</form>\n";
}


sub retourbbsadminlist {
	print "<form method=POST action=\"resooboardadmin.pl\">\n";
	print "<CENTER><TABLE BORDER=0>\n";
	print "<input type=hidden name=\"util\" value=\"$util\">\n";
	print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
	print "<input type=hidden name=\"action\" value=\"52\">\n";
	print "<TR><TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\"   retour liste suppression/dition   \"></TD></TR>\n";
	print "</TABLE></CENTER>\n";
	print "</form>\n";
}


######## console admin ########

sub consolebbs {
    print "<CENTER><TABLE WIDTH=90% BORDER=1>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD COLSPAN=2 ALIGN=CENTER>$font Accs  la liste suppression/dition : <br>(liste complte)$finfont</TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"52\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * LISTE COMP * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD COLSPAN=2 ALIGN=CENTER>$font Accs  la liste suppression/archivage : <br>(sujet de discussion seul)$finfont</TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"59\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * LISTE ARCH * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD COLSPAN=2 ALIGN=CENTER>$font Affichage des logs/messages : $finfont</TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"50\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * LISTE LOG_ * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD ALIGN=CENTER>$font N de message  diter : $finfont</TD>\n";
    print "<TD ALIGN=CENTER><input type=text name=\"delfichier\" size=10 value=\"\"></TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"40\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * EDIT_ * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD ALIGN=CENTER>$font N du message  effacer : $finfont</TD>\n";
    print "<TD ALIGN=CENTER><input type=text name=\"delfichier\" size=10 value=\"\"></TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"42\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * EFF__ * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD ALIGN=CENTER>$font N du message  supprimer : <br>(seul le message est supprim) $finfont</TD>\n";
    print "<TD ALIGN=CENTER><input type=text name=\"delfichier\" size=10 value=\"\"></TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"48\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * SUPP_ * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "<form method=POST action=\"resooboardadmin.pl\">\n";
    print "<TR><TD ALIGN=CENTER>$font N du sujet  supprimer : <br>(ses rponses sont aussi supprimes) $finfont</TD>\n";
    print "<TD ALIGN=CENTER><input type=text name=\"deltopic\" size=10 value=\"\"></TD>\n";
    print "<input type=hidden name=\"util\" value=\"$util\">\n";
    print "<input type=hidden name=\"pass\" value=\"$pass\">\n";
    print "<input type=hidden name=\"action\" value=\"49\">\n";
    print "<TD ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE=\" * T_SUP * \"></TD></TR></form>\n";

    print "<TR><TD COLSPAN=3 ALIGN=CENTER><hr></TD></TR></form>\n";

    print "</TABLE></CENTER>\n";
}
