#!/usr/bin/perl

#
#  REF: resooboard.pl
#  ResooSite v.0.9.5.3-1 -(p)Resoo 2002-2004
#  (c)2004 - pascal blain / GNU GPL - General Public License
#  http://www.resoo.com/resoosite
#  pascal@resoo.org
#

require "resooconf.pl";
require "resoobbsconf.pl";

use CGI qw(:all); ## fonction "remote_host"

###########################################################################
# Subroutine

# Obtenir les informations du formulaire
	&parse_form;
# Mettre les champs dans des variables
	&get_variables;
# Obtenir le nb de messages (data)
	&get_number;
	&get_date;
# Ouvrir un nouveau fichier et y ecrire les infos
	&new_file;
    if ($action == 11) {
    # Crer une balise topic s'il y a lieu
        &main_page;
    # Lier message et reponse s'il y a lieu
        &thread_pages;
    }
# Retourner une page HTML a l'utilisateur
	&return_html;
# Incrementer le compteur
	&increment_num;


########################################
# Obtenir le nb de messages - Subroutine

sub get_number {
    if ($action == 11) {
	$wfile = "$dir_bbs/$datafile";
    }
    else {
	$wfile = "$dir_bbs/$datafiletmp";
    }
    if (!(-e $wfile)){open(NEW,"> $wfile");print NEW "0";close(NEW); }
    open(NUMBER,"$wfile") || die $!;;
    $num = <NUMBER>;
    close(NUMBER);
    if ($num == 999999)  {
	$num = "1";
    }
    else {
	$num++;
    }
}

#####################################################
# Obtenir les informations du formulaire - Subroutine

sub parse_form {

    # Get the input
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

    # Split the name-value pairs
    @pairs = split(/&/, $buffer);

    foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);

        # Un-Webify plus signs and %-encoding
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/<!--(.|\n)*-->//g;

        if ($allow_html != 1) {
             $value =~ s/<([^>]|\n)*>//g;
        }
        else {
            unless ($name eq 'bbsbodymess') {
		$value =~ s/<([^>]|\n)*>//g;
    	    }
	}

	$FORM{$name} = $value;
    }

}

###################################################
# Mettre les champs dans des variables - Subroutine

sub get_variables {

    if ($FORM{'action'}) {
	$action = "$FORM{'action'}";
    }
    else {
        $action = "";
    }

    if ($FORM{'orignum'}) {
        $orignum = "$FORM{'orignum'}";
    }
    else {
        $orignum = "";
    }

    if ($FORM{'num'}) {
        $num = "$FORM{'num'}";
    }
    else {
        $num = "";
    }

    if ($FORM{'delfichier'}) {
        $delfichier = "$FORM{'delfichier'}";
    }
    else {
        $delfichier = "";
    }

    if ($FORM{'bbsname'}) {
        $bbsname = "$FORM{'bbsname'}";
        $bbsname =~ s/\"//g;
        $bbsname =~ s/<//g;
        $bbsname =~ s/>//g;
        $bbsname =~ s/\&//g;
	chomp($bbsname);
	$bbsname =~ s/\r//g;
	$bbsname =~ s/\n/ /g;
	##### a voir: controle du nombre de caractres
    }
    else {
        &error(no_name);
    }

    if ($FORM{'bbsemail'} =~ /.*\@.*\..*/) {
        $bbsemail = "$FORM{'bbsemail'}";
    }

    if ($FORM{'bbssubject'}) {
        $bbssubject = "$FORM{'bbssubject'}";
        $bbssubject =~ s/\&/\&amp\;/g;
        $bbssubject =~ s/\"/\&quot\;/g;
        $bbssubject = lc($bbssubject);
	chomp($bbssubject);
	$bbssubject =~ s/\r//g;
	$bbssubject =~ s/\n/ /g;
	##### a voir: controle du nombre de caractres
    }
    else {
        &error(no_subject);
    }

    if ($FORM{'message_url'} =~ /.*\:.*\..*/ && $FORM{'message_url_title'}) {
        $message_url = "$FORM{'message_url'}";
        chomp($message_url);
	$message_url =~ s/\r//g;
	$message_url =~ s/\n/ /g;
	$message_url_title = "$FORM{'message_url_title'}";
        chomp($message_url_title);
	$message_url_title =~ s/\r//g;
	$message_url_title =~ s/\n/ /g;
	##### a voir: controle du nombre de caractres
    }

    if ($FORM{'img'} =~ /.*tp:\/\/.*\..*/) {
        $message_img = "$FORM{'img'}";
        chomp($message_img);
	$message_img =~ s/\r//g;
	$message_img =~ s/\n/ /g;
	##### a voir: controle du nombre de caractres
    }

    if ($FORM{'bbsbodymess'}) {
	$bbsbodymess = "$FORM{'bbsbodymess'}";
        $bbsbodymess =~ s/\cM//g;
        $bbsbodymess =~ s/\n\n/<p>/g;
        $bbsbodymess =~ s/\n/<br>/g;

        $bbsbodymess =~ s/&lt;/</g; 
        $bbsbodymess =~ s/&gt;/>/g; 
	$bbsbodymess =~ s/&quot;/\"/g;
	$renew = $bbsbodymess;
	&unword;
	$bbsbodymess = $renew;
    }
    else {
	&error(no_body);
    }

    unless (!$moderation) {
    
	if ($FORM{'passbbs'}) {
	    $passbbs = "$FORM{'passbbs'}";
    	    chomp($passbbs);
	    $passbbs =~ s/\r//g;
	    $passbbs =~ s/\n/ /g;
    	    ##### a voir: controle du nombre de caractres
	    $util = "users";
	    $action = "";
	    &verify;
	}
	else {
	    $passbbs = "";
	    $util = "";
	    $action = "";
	}
    }
}  

##############################################################
# Ouvrir un nouveau fichier et y ecrire les infos - Subroutine

sub new_file {

if ($action == 11) {
    $wfile = "$mesgdir/$num\.$ext1";
    open(NEWFILE,">$wfile") || &error(no_perm);
    print NEWFILE remote_host." [PASS]\n";
}
else {
    $wfile = "$mesgdirtmp/$num\.$ext1";
    open(NEWFILE,">$wfile") || &error(no_perm);
    print NEWFILE remote_host."\n";
}
    print NEWFILE "$bbsname\n";
    print NEWFILE "$bbsemail\n";
    print NEWFILE "$date\n";
    print NEWFILE "$heure\n";
    print NEWFILE "$bbssubject\n";
    print NEWFILE "$bbsbodymess\n";
    print NEWFILE "$num\n"; ## le numro du message
    print NEWFILE "|\n"; ## les rponses ($followup)
    print NEWFILE "$orignum\n"; ## le num du message prcdent
    print NEWFILE "$message_img\n";
    print NEWFILE "$message_url\n";
    print NEWFILE "$message_url_title\n";
    close(NEWFILE);
}

#############################################################
# Ouvrir le fichier principal et ajouter un lien - Subroutine

sub main_page {

   if (!$orignum) {
        my $wfile = "$mesgdir/$num\.$ext2";
        open(MAIN,">$wfile") || &error(no_perm);
        @main = <MAIN>;
        print MAIN "1";
        close(MAIN);
   }
}

######################################################
# Lier le message  son message d'origine - Subroutine

sub thread_pages {

    if ($orignum) {
        my $wfile = "$mesgdir/$orignum\.$ext1";
	open(MODFILE,"$wfile") || &error(no_file);
	@modfile = <MODFILE>;
	close(MODFILE);
	my $followup = @modfile[8];
	$followup =~ s/\n//;
	@modfile[8] = "$followup$num|\n";
	open(NEWFILE,">$wfile") || &error(no_perm);
	foreach $line(@modfile) {
	    print NEWFILE "$line";
        }
	close(NEWFILE);
    }
}

######################################################
# Retourner une page HTML a l'utilisateur - Subroutine

sub return_html {
    print "Content-type: text/html\; charset=ISO-8859-1\n\n";
    &head_bbs;
    print "<table border=\"0\" width=\"600\">\n";
    print "<tr>\n";
    print "<td width=\"600\" colspan=\"3\">\n";
    print "$font\n";

    print "<center><h2>Message envoy: $bbssubject</h2></center>\n";
    if ($action == 11) {
	print "Les informations suivantes ont t ajoutes au site:<p><hr size=7 width=75%><p>\n";
    }
    else {
	print "Les informations suivantes seront ajoutes au site dans les prochaines heures:<p><hr size=7 width=75%><p>\n";
    }
    print "<u>Nom:</u>$fontbbs $bbsname $finfontbbs<br>\n";
    if ($bbsemail) {
	print "<b>E-Mail:</b>$fontbbs $bbsemail $finfontbbs<br>\n";
    }
    print "<u>Titre:</u>$fontbbs $bbssubject $finfontbbs<br>\n";
    print "<u>Message:</u><p>\n";
    print "<UL>$fontbbs $bbsbodymess $finfontbbs</UL><p>\n";
    print "<u>Ajout le:</u>$fontbbs $date $finfontbbs<p>\n";
    print "<hr size=7 width=75%>\n";
    print "<center>";
    print "[ <a href=\"$bbslink\"><b>Retour $forumtitre</b></a> ]</center>\n";

    print "$finfont\n";
    print "</td>\n";
    print "</tr>\n";
    print "</table>\n";
    &foot_gen;
}

######################################
# Incrementer le compteur - Subroutine

sub increment_num {
    if ($action == 11) {
	open(NUM,">$dir_bbs/$datafile") || die $!;
    }
    else {
	open(NUM,">$dir_bbs/$datafiletmp") || die $!;
    }
    print NUM "$num";
    close(NUM);
}

######## verification mot de passe ########

sub verify {
   open(MAIN,"$private/$util.pass") || &error(no_pass);
   @main = <MAIN>;
   close(MAIN);
   foreach $main_line(@main) {
        chomp $main_line;
        if (($main_line =~ /^BBS$passbbs$/) or ($main_line =~ /^ALL$passbbs$/)) {
	    $action = "11";
        }
    }
    if (!($action == 11)) {
	&error(bad_pass);
    }
}
